<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template name="InnerClassSummary">
		<xsl:param name="title"></xsl:param>
		<xsl:param name="nodeset"></xsl:param>
		
		<xsl:if test="$nodeset">
			
			<!-- Heading -->
			<a name="inner_summary"></a>
			<table border="1" cellpadding="3" cellspacing="0" width="100%">
			<tr class="TableHeaderStyle">
			<td colspan="2">
			<font size="+2">
			<b>
				<xsl:value-of select="$title"></xsl:value-of>
			</b>
			</font>
			</td>
			</tr>
			
			<!-- Contents -->
			<xsl:for-each select="$nodeset">
			
			<xsl:variable name="description">
				<xsl:apply-templates select="current()" mode="getDescription"/>
			</xsl:variable>
			
			<tr class="TableRow">
			<td align="right" valign="top" width="20%">
			<font size="-1">
			<code>
				<xsl:text disable-output-escaping="yes">&amp;nbsp</xsl:text>
				<!-- definition string -->
				<xsl:call-template name="ClassifierDefinitionString">
					<xsl:with-param name="class" select="current()"></xsl:with-param>
				</xsl:call-template>
			</code>
			</font>
			</td>
			
			<td>
			<b>
			<xsl:apply-templates select="current()" mode="HRefWithImgLoad"/>
			</b>
			<br/><xsl:text>&#x9;</xsl:text>
			<xsl:choose>
				<xsl:when test="string-length($description) &gt; 0">
					<xsl:value-of select="$description"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>&#xA0;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
			</td>
			</tr>
			
			</xsl:for-each>			
			
			</table>
			<p/>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
